<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends CI_Controller
{
    /** @var CI_Loader */
    public $load;
    /** @var CI_Input */
    public $input;
    /** @var CI_Session */
    public $session;
    /** @var CI_Form_validation */
    public $form_validation;
    /** @var User_model */
    public $User_model;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->helper(['url', 'form']);
        $this->load->library(['session', 'form_validation']);
    }

    public function index()
    {
        // Redirect to login page
        redirect('auth/login');
    }

    public function login()
    {
        if ($this->input->post()) {
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
            $this->form_validation->set_rules('password', 'Password', 'required');
            if ($this->form_validation->run() == TRUE) {
                $user = $this->User_model->get_by_email($this->input->post('email'));
                if ($user && password_verify($this->input->post('password'), $user->password)) {
                    $this->session->set_userdata(['logged_in' => TRUE, 'user_id' => $user->id, 'name' => $user->name]);
                    redirect('dashboard');
                } else {
                    $data['error'] = 'Email atau password salah.';
                }
            }
        }
        $this->load->view('auth/login', isset($data) ? $data : NULL);
    }

    public function register()
    {
        if ($this->input->post()) {
            $this->form_validation->set_rules('name', 'Nama', 'required');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
            if ($this->form_validation->run() == TRUE) {
                $data = [
                    'name' => $this->input->post('name'),
                    'email' => $this->input->post('email'),
                    'password' => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ];
                $this->User_model->insert($data);
                redirect('auth/login');
            }
        }
        $this->load->view('auth/register');
    }

    public function logout()
    {
        $this->session->sess_destroy();
        redirect('auth/login');
    }
}
