<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Domain extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['Domain_model', 'Path_model']);
        $this->load->database();
        $this->load->helper(['url', 'form']);
        $this->load->library(['session', 'form_validation']);
        if (!$this->session->userdata('logged_in'))
            redirect('auth/login');
    }

    public function index()
    {
        $search = $this->input->get('search');
        if ($search) {
            $data['domains'] = $this->Domain_model->search_domains($search);
        } else {
            $data['domains'] = $this->Domain_model->get_domains(); // semua domain
        }
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('domain/domain', $data);
        $this->load->view('templates/footer');
    }

    // Add atau ganti domain
    public function add()
    {
        if ($this->input->method() === 'post') {
            $old_domain = strtolower(trim($this->input->post('old_domain')));
            $new_domain = strtolower(trim($this->input->post('new_domain')));
            $api_key = trim($this->input->post('api_key'));
            $user_id = $this->session->userdata('user_id');

            if (empty($old_domain) || empty($new_domain)) {
                $this->session->set_flashdata('error', 'Domain lama dan domain baru harus diisi.');
                redirect('domain');
            }

            $domain_row = $this->db->get_where('domains', ['domain_name' => $old_domain])->row();
            if (!$domain_row) {
                $this->session->set_flashdata('error', 'Domain lama tidak ditemukan.');
                redirect('domain');
            }

            // 1️⃣ Update domain di tabel domains
            $this->db->where('id', $domain_row->id)->update('domains', [
                'domain_name' => $new_domain,
                'api_key' => $api_key,
                'updated_at' => date('Y-m-d H:i:s')
            ]);

            // 2️⃣ Simpan ke tabel history
            $this->db->insert('history', [
                'domain_id' => $domain_row->id,
                'old_domain' => $old_domain,
                'new_domain' => $new_domain,
                'user_id' => $user_id,
                'created_at' => date('Y-m-d H:i:s')
            ]);

            // 3️⃣ Update URL di paths & links tanpa mengubah shortlink
            $this->Path_model->update_urls_by_domain($domain_row->id, $old_domain, $new_domain, $user_id);

            $this->session->set_flashdata('success', "Domain <b>{$old_domain}</b> berhasil diganti ke <b>{$new_domain}</b>.");
            redirect('domain');
        }
    }

    // Edit domain
    public function edit($id)
    {
        $domain = $this->Domain_model->get_by_id($id);
        if (!$domain) {
            $this->session->set_flashdata('error', 'Domain tidak ditemukan.');
            redirect('domain');
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('new_domain', 'Domain Baru', 'required');
            $this->form_validation->set_rules('api_key', 'API Key', 'required');

            if ($this->form_validation->run() == TRUE) {
                $old_domain = $domain->domain_name;
                $new_domain = strtolower(trim($this->input->post('new_domain')));
                $api_key = trim($this->input->post('api_key'));
                $user_id = $this->session->userdata('user_id');

                // 1️⃣ Update domain
                $this->Domain_model->update($id, [
                    'domain_name' => $new_domain,
                    'api_key' => $api_key,
                    'updated_at' => date('Y-m-d H:i:s')
                ]);

                // 2️⃣ Simpan ke history
                $this->db->insert('history', [
                    'domain_id' => $id,
                    'old_domain' => $old_domain,
                    'new_domain' => $new_domain,
                    'user_id' => $user_id,
                    'created_at' => date('Y-m-d H:i:s')
                ]);

                // 3️⃣ Update URL di paths & links
                $this->Path_model->update_urls_by_domain($id, $old_domain, $new_domain, $user_id);

                $this->session->set_flashdata('success', "Domain berhasil diganti: {$old_domain} → {$new_domain}");
                redirect('domain');
            } else {
                $this->session->set_flashdata('error', validation_errors());
                redirect('domain');
            }
        }

        $data['domain'] = $domain;
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('domain/edit', $data);
        $this->load->view('templates/footer');
    }

    public function delete($id)
    {
        $this->Domain_model->delete($id);
        $this->session->set_flashdata('success', 'Domain berhasil dihapus.');
        redirect('domain');
    }
}
