<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Migration extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['Domain_model', 'Path_model', 'Migration_log_model']);
        $this->load->helper(['url', 'form']);
        $this->load->library(['session', 'form_validation']);
        if (!$this->session->userdata('logged_in'))
            redirect('auth/login');
    }

    // AJAX endpoint: ambil semua path yang akan dimigrasi
    public function ajax_mass_replace()
    {
        $domain_id = $this->input->post('domain_id');
        $paths = $this->Path_model->get_paths_by_domain($domain_id);
        $result = [
            'total' => count($paths),
            'paths' => array_map(function ($p) {
                return ['id' => $p->id];
            }, $paths)
        ];
        echo json_encode($result);
        }

    // AJAX endpoint: proses migrasi satu path
    public function ajax_process_path()
    {
        $input = json_decode(file_get_contents('php://input'), true);
        $path_id = $input['path_id'];
        $domain_id = $input['domain_id'];

        $domain = $this->Domain_model->get_by_id($domain_id);
        $path = $this->Path_model->get_by_id($path_id);

        if (!$domain || !$path) {
            echo json_encode(['success' => false, 'message' => 'Domain atau path tidak ditemukan']);
            return;
        }

        // Gunakan domain_name terbaru, bukan old_domain/new_domain
        $old_url = $path->full_url;
        $parsed = parse_url($old_url);
        $path_part = $parsed['path'] ?? '';
        if (isset($parsed['query']))
            $path_part .= '?' . $parsed['query'];
        if (isset($parsed['fragment']))
            $path_part .= '#' . $parsed['fragment'];

        $new_url = 'https://' . $domain->domain_name . $path_part;

        $update = $this->Path_model->update($path->id, ['full_url' => $new_url]);

        if ($update) {
            echo json_encode(['success' => true, 'message' => "Path {$path->id} berhasil dimigrasi."]);
        } else {
            echo json_encode(['success' => false, 'message' => "Path {$path->id} gagal dimigrasi."]);
        }
    }

    // Restore migrasi
    public function restore_migration($log_id)
    {
        $log = $this->Migration_log_model->get_log_by_id($log_id);
        if (!$log) {
            $this->session->set_flashdata('error', 'Log migrasi tidak ditemukan.');
            redirect('migration');
            return;
        }

        $domain = $this->Domain_model->get_by_id($log->domain_id);
        if (!$domain) {
            $this->session->set_flashdata('error', 'Domain tidak ditemukan.');
            redirect('migration');
            return;
        }

        $paths = $this->Path_model->get_paths_by_domain($domain->id);
        $success = 0;
        $failed = 0;
        $errors = [];

        foreach ($paths as $path) {
            $current_url = $path->full_url;
            $restored_url = str_replace($domain->domain_name, $log->old_domain, $current_url);

            $update = $this->Path_model->update($path->id, ['full_url' => $restored_url]);
            if ($update) {
                $success++;
            } else {
                $failed++;
                $errors[] = [
                    'path_id' => $path->id,
                    'current_url' => $current_url,
                    'restored_url' => $restored_url,
                    'error' => 'Restore gagal',
                ];
            }
        }

        $this->session->set_flashdata('success', "Restore selesai. Berhasil: $success, Gagal: $failed");
        $this->session->set_flashdata('restore_errors', $errors);
        redirect('migration');
    }

    // Halaman utama migrasi
    public function index()
    {
        // Ambil semua domain terbaru dari tabel domains, untuk dropdown
        $data['domains'] = $this->Domain_model->get_domains_for_migration();

        // Ambil semua migration log
        $data['migration_logs'] = $this->Migration_log_model->get_migration_per_domain();

        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('migration', $data);
        $this->load->view('templates/footer');
    }

    // Halaman mass replace
    public function mass_replace()
    {
        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            $domain_id = $this->input->post('domain_id');
            $cuttly_api_key = $this->input->post('cuttly_api_key');
            $domain = $this->Domain_model->get_by_id($domain_id);
            if (!$domain) {
                $this->session->set_flashdata('error', 'Domain tidak ditemukan.');
                redirect('migration/mass_replace');
                return;
            }
            $paths = $this->Path_model->get_paths_by_domain($domain_id);
            $success = 0;
            $failed = 0;
            $errors = [];
            foreach ($paths as $path) {
                $old_url = $path->full_url;
                $parsed = parse_url($old_url);
                $path_part = $parsed['path'] ?? '';
                if (isset($parsed['query']))
                    $path_part .= '?' . $parsed['query'];
                if (isset($parsed['fragment']))
                    $path_part .= '#' . $parsed['fragment'];
                $new_url = 'https://' . $domain->domain_name . $path_part;
                $update = $this->Path_model->update($path->id, ['full_url' => $new_url]);
                if ($update) {
                    $success++;
                } else {
                    $failed++;
                    $errors[] = [
                        'path_id' => $path->id,
                        'old_url' => $old_url,
                        'new_url' => $new_url,
                        'error' => 'Migrasi gagal',
                    ];
                }
            }
            // Simpan log migrasi
            $this->Migration_log_model->insert([
                'domain_id' => $domain_id,
                'success_count' => $success,
                'failed_count' => $failed,
                'created_at' => date('Y-m-d H:i:s'),
            ]);
            $this->session->set_flashdata('success', "Migrasi massal selesai. Berhasil: $success, Gagal: $failed");
            $this->session->set_flashdata('migration_errors', $errors);
            redirect('migration/mass_replace');
            return;
        }
        // Ambil semua domain terbaru dari tabel domains, untuk dropdown
        $data['domains'] = $this->Domain_model->get_domains_for_migration();
        // Ambil semua migration log
        $data['migration_logs'] = $this->Migration_log_model->get_migration_per_domain();
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('migration', $data);
        $this->load->view('templates/footer');
    }
}
