<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Profile extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->helper(['url', 'form']);
        $this->load->library(['session', 'form_validation']);
        if (!$this->session->userdata('logged_in'))
            redirect('auth/login');
    }
    /** @var CI_Loader */
    public $load;
    /** @var CI_Input */
    public $input;
    /** @var CI_Session */
    public $session;
    /** @var CI_Form_validation */
    public $form_validation;
    /** @var User_model */
    public $User_model;

    public function index()
    {
        $user = $this->User_model->get_by_id($this->session->userdata('user_id'));
        $data['user'] = $user;
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('profile/profile', $data);
        $this->load->view('templates/footer');
    }

    public function edit()
    {
        $user = $this->User_model->get_by_id($this->session->userdata('user_id'));
        if ($this->input->post()) {
            $this->form_validation->set_rules('name', 'Nama', 'required');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
            if ($this->form_validation->run() == TRUE) {
                $update = [
                    'name' => $this->input->post('name'),
                    'email' => $this->input->post('email'),
                    'updated_at' => date('Y-m-d H:i:s')
                ];
                $this->User_model->update($user->id, $update);
                redirect('profile');
            }
        }
        $data['user'] = $user;
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('profile/profile_edit', $data);
        $this->load->view('templates/footer');
    }

    public function change_password()
    {
        if ($this->input->post()) {
            // Remove old_password validation
            $this->form_validation->set_rules('new_password', 'Password Baru', 'required|min_length[6]');
            $user = $this->User_model->get_by_id($this->session->userdata('user_id'));
            if ($this->form_validation->run() == TRUE) {
                $this->User_model->update($user->id, ['password' => password_hash($this->input->post('new_password'), PASSWORD_DEFAULT)]);
                $data['success'] = 'Password berhasil diubah.';
            } else {
                $data['error'] = 'Input tidak valid.';
            }
        }
        $this->load->view('templates/header');
        $this->load->view('templates/sidebar');
        $this->load->view('profile/profile_password', isset($data) ? $data : NULL);
        $this->load->view('templates/footer');
    }
}
