<?php
defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('call_cuttly_api')) {
    function call_cuttly_api($url, $api_key = null, $custom = null)
    {
        $CI =& get_instance();
        $api_key = $api_key ?? $CI->config->item('cuttly_api_key');
        $api_url = $CI->config->item('cuttly_api_url');

        $params = ['key' => $api_key, 'short' => $url];
        if ($custom) {
            $params['name'] = $custom;
        }
        $request_url = $api_url . '?' . http_build_query($params);

        $response = @file_get_contents($request_url);
        if ($response === FALSE) {
            log_message('error', 'Cuttly API request failed: ' . $request_url);
            return null;
        }

        $data = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            log_message('error', 'Cuttly API JSON decode error: ' . json_last_error_msg());
            return null;
        }

        if (isset($data['url']['status'])) {
            if ($data['url']['status'] == 7) {
                return $data['url']['shortLink'] ?? null;
            } else {
                log_message('error', 'Cuttly API returned error status: ' . $data['url']['status'] . ' Response: ' . $response);
            }
        } else {
            log_message('error', 'Cuttly API response missing status field. Response: ' . $response);
        }

        return null;
    }
}
