<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_pertoko_tables extends CI_Migration {

    private $tables = [
        'ompong188_links',
        'botak123_links',
        'sakti123_links',
        'pasar123_links',
        'cuan123_links',
        'jablay123_links',
        'candu123_links',
        'mampir_links',
        'becekwin_links',
        'jenius_links',
        'gendut188_links'
    ];

    public function up()
    {
        foreach ($this->tables as $table) {
            if (!$this->db->table_exists($table)) {
                $this->dbforge->add_field([
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'unsigned' => TRUE,
                        'auto_increment' => TRUE
                    ],
                    'domain' => [
                        'type' => 'VARCHAR',
                        'constraint' => '255',
                        'null' => FALSE
                    ],
                    'path' => [
                        'type' => 'VARCHAR',
                        'constraint' => '255',
                        'null' => FALSE
                    ],
                    'url' => [
                        'type' => 'TEXT',
                        'null' => FALSE
                    ],
                    'shortlink' => [
                        'type' => 'TEXT',
                        'null' => FALSE
                    ],
                    'status' => [
                        'type' => 'ENUM',
                        'constraint' => ['active', 'inactive'],
                        'default' => 'active',
                        'null' => FALSE
                    ],
                    'created_at' => [
                        'type' => 'TIMESTAMP',
                        'default' => 'CURRENT_TIMESTAMP',
                        'null' => FALSE
                    ]
                ]);
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table($table);
            }
        }
    }

    public function down()
    {
        foreach ($this->tables as $table) {
            if ($this->db->table_exists($table)) {
                $this->dbforge->drop_table($table);
            }
        }
    }
}
