<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Update_pertoko_tables extends CI_Migration {

    private $tables = [
        'ompong188_links',
        'botak123_links',
        'sakti123_links',
        'pasar123_links',
        'cuan123_links',
        'jablay123_links',
        'candu123_links',
        'mampir_links',
        'becekwin_links',
        'jenius_links',
        'gendut188_links'
    ];

    public function up()
    {
        foreach ($this->tables as $table) {
            // Add 'domain' column if not exists
            if (!$this->db->field_exists('domain', $table)) {
                $this->dbforge->add_column($table, [
                    'domain' => [
                        'type' => 'VARCHAR',
                        'constraint' => '255',
                        'null' => FALSE,
                        'default' => ''
                    ]
                ]);
            }

            // Add 'url' column if not exists
            if (!$this->db->field_exists('url', $table)) {
                $this->dbforge->add_column($table, [
                    'url' => [
                        'type' => 'TEXT',
                        'null' => FALSE
                    ]
                ]);
            }

            // Add 'status' column if not exists
            if (!$this->db->field_exists('status', $table)) {
                $this->dbforge->add_column($table, [
                    'status' => [
                        'type' => 'ENUM',
                        'constraint' => ['active', 'inactive'],
                        'default' => 'active',
                        'null' => FALSE
                    ]
                ]);
            }

            // Optionally, drop 'domain_id' column if exists
            if ($this->db->field_exists('domain_id', $table)) {
                $this->dbforge->drop_column($table, 'domain_id');
            }
        }
    }

    public function down()
    {
        foreach ($this->tables as $table) {
            // Remove added columns
            if ($this->db->field_exists('domain', $table)) {
                $this->dbforge->drop_column($table, 'domain');
            }
            if ($this->db->field_exists('url', $table)) {
                $this->dbforge->drop_column($table, 'url');
            }
            if ($this->db->field_exists('status', $table)) {
                $this->dbforge->drop_column($table, 'status');
            }

            // Optionally, add back 'domain_id' column
            if (!$this->db->field_exists('domain_id', $table)) {
                $this->dbforge->add_column($table, [
                    'domain_id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'null' => FALSE,
                        'default' => 0
                    ]
                ]);
            }
        }
    }
}
