<?php
class Domain_model extends CI_Model
{
    public function get_all_by_user($user_id)
    {
        return $this->db->get_where('domains', ['user_id' => $user_id])->result();
    }
    public function get_by_id($id)
    {
        return $this->db->get_where('domains', ['id' => $id])->row();
    }
    public function insert($data)
    {
        return $this->db->insert('domains', $data);
    }
    public function update($id, $data)
    {
        return $this->db->where('id', $id)->update('domains', $data);
    }
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete('domains');
    }
    public function count_all()
    {
        return $this->db->count_all('domains');
    }

    public function get_by_id_user($id, $user_id)
    {
        return $this->db->where('id', $id)
            ->where('user_id', $user_id)
            ->get('domains')
            ->row();
    }
    public function search_by_user($user_id)
    {
        return $this->db->get_where('domains', ['user_id' => $user_id])->result();
    }

    public function add_domain($domain_name, $user_id = null)
    {
        $data = array(
            'domain_name' => $domain_name,
            'user_id' => $user_id,
            'status' => 'active'
        );
        return $this->db->insert('domains', $data);
    }

    public function get_domains()
    {
        $query = $this->db->get('domains');
        return $query->result();
    }

    public function get_domains_by_toko($toko_id)
    {
        $query = $this->db->get_where('domains', ['toko_id' => $toko_id]);
        return $query->result();
    }

    public function get_domain_by_name_and_toko($domain_name, $toko_id)
    {
        $query = $this->db->get_where('domains', ['domain_name' => $domain_name, 'toko_id' => $toko_id]);
        return $query->row();
    }

    public function search_domains($keyword)
    {
        $this->db->like('domain_name', $keyword);
        $this->db->or_like('api_key', $keyword);
        $query = $this->db->get('domains');
        return $query->result();
    }

    public function get_domain($id)
    {
        $query = $this->db->get_where('domains', array('id' => $id));
        return $query->row();
    }

    public function update_domain($id, $domain_name, $user_id = null)
    {
        // 1. Ambil data domain lama
        $old_domain = $this->db->get_where('domains', ['id' => $id])->row();

        if ($old_domain) {
            // 2. Update domain di tabel domains
            $this->db->where('id', $id);
            $this->db->update('domains', [
                'domain_name' => $domain_name,
                'updated_at' => date('Y-m-d H:i:s')
            ]);

            // 3. Insert ke tabel history
            $this->db->insert('history', [
                'domain_id' => $id,
                'old_domain' => $old_domain->domain_name,
                'new_domain' => $domain_name,
                'user_id' => $user_id,
                'created_at' => date('Y-m-d H:i:s')
            ]);

            return true;
        }

        return false;
    }

    public function delete_domain($id)
    {
        return $this->db->delete('domains', array('id' => $id));
    }

    public function get_domains_for_migration()
    {
        return $this->db->select('id, domain_name')
            ->from('domains')
            ->order_by('domain_name', 'ASC')
            ->get()
            ->result();
    }

}
