<?php
class Migration_log_model extends CI_Model
{
    public function get_log_by_id($id)
    {
        return $this->db->get_where('migration_logs', ['id' => $id])->row();
    }
    public function insert($data)
    {
        return $this->db->insert('migration_logs', $data);
    }
    public function get_status_summary()
    {
        $this->db->select('status, COUNT(*) as total');
        $this->db->group_by('status');
        return $this->db->get('migration_logs')->result();
    }
    public function get_migration_per_domain()
    {
        $this->db->select('migration_logs.id, migration_logs.success_count, migration_logs.failed_count, migration_logs.created_at, domains.domain_name');
        $this->db->from('migration_logs');
        $this->db->join('domains', 'migration_logs.domain_id = domains.id', 'left');
        $this->db->order_by('migration_logs.created_at', 'desc');
        return $this->db->get()->result();
    }
}
