<?php
class Path_model extends CI_Model
{
    public function get_all_by_user($user_id)
    {
        $this->db->select('paths.*, domains.domain_name, domains.old_domain, domains.new_domain');
        $this->db->join('domains', 'domains.id = paths.domain_id');
        $this->db->where('domains.user_id', $user_id);
        return $this->db->get('paths')->result();
    }
    public function get_by_id($id)
    {
        return $this->db->get_where('paths', ['id' => $id])->row();
    }
    public function insert($data)
    {
        return $this->db->insert('paths', $data);
    }
    public function update($id, $data)
    {
        return $this->db->where('id', $id)->update('paths', $data);
    }
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete('paths');
    }
    public function count_all()
    {
        return $this->db->count_all('paths');
    }

    public function create_path($data)
    {
        return $this->db->insert('paths', $data);
    }

    // Method to retrieve all paths
    public function get_paths()
    {
        return $this->db->get('paths')->result();
    }

    // Method to retrieve paths associated with a specific domain
    public function get_paths_by_domain($domain_id)
    {
        return $this->db->get_where('paths', ['domain_id' => $domain_id])->result();
    }

    // New method to retrieve paths by domain_id from a specified table (dynamic toko table)
    public function get_paths_by_domain_from_table($table_name, $domain_id)
    {
        if (!$this->db->table_exists($table_name)) {
            return [];
        }
        return $this->db->get_where($table_name, ['domain_id' => $domain_id])->result();
    }

    // Method to update an existing path
    public function update_path($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('paths', $data);
    }

    // Method to delete a path
    public function delete_path($id)
    {
        return $this->db->delete('paths', ['id' => $id]);
    }

    // Method to generate a shortlink
    public function generate_shortlink($path)
    {
        return 'short/' . substr(md5($path), 0, 6);
    }

    // Method to update multiple paths by domain and old path
    public function update_paths_by_domain_and_path($domain_id, $old_path, $new_path)
    {
        // Get all paths matching domain_id and old_path
        $paths = $this->db->get_where('paths', ['domain_id' => $domain_id, 'path' => $old_path])->result();

        foreach ($paths as $path) {
            // Form new URL
            $domain_name = $this->get_domain_name($domain_id);
            $new_url = rtrim($domain_name, '/') . '/' . ltrim($new_path, '/');

            // Prepend https:// if missing
            if (!preg_match('#^https?://#i', $new_url)) {
                $new_url = 'https://' . $new_url;
            }

            // Update path and url, keep shortlink unchanged
            $this->db->where('id', $path->id);
            $this->db->update('paths', [
                'path' => $new_path,
                'url' => $new_url,
            ]);
        }
        return true;
    }

    // Helper method to get domain name by domain_id
    private function get_domain_name($domain_id)
    {
        $domain = $this->db->get_where('domains', ['id' => $domain_id])->row();
        return $domain ? $domain->domain_name : '';
    }

    // New method to update URLs in paths table by replacing old domain with new domain for a given domain_id
    public function update_urls_by_domain($domain_id, $old_domain, $new_domain, $user_id = null)
    {
        // 1️⃣ Simpan ke history
        $this->db->insert('history', [
            'domain_id' => $domain_id,
            'old_domain' => $old_domain,
            'new_domain' => $new_domain,
            'user_id' => $user_id,
            'created_at' => date('Y-m-d H:i:s')
        ]);

        // 2️⃣ Update paths
        $paths = $this->db->get_where('paths', ['domain_id' => $domain_id])->result();
        foreach ($paths as $path) {
            $parsed_url = parse_url($path->url);
            $path_part = $parsed_url['path'] ?? '';
            $new_url = 'https://' . $new_domain . $path_part;
            if (isset($parsed_url['query']))
                $new_url .= '?' . $parsed_url['query'];
            if (isset($parsed_url['fragment']))
                $new_url .= '#' . $parsed_url['fragment'];

            // Hanya update URL, shortlink tetap
            $this->db->where('id', $path->id)
                ->update('paths', ['url' => $new_url]);
        }

        // 3️⃣ Update links
        $links = $this->db->get_where('links', ['domain_id' => $domain_id])->result();
        foreach ($links as $link) {
            $parsed_url = parse_url($link->url);
            $path_part = $parsed_url['path'] ?? '';
            $new_url = 'https://' . $new_domain . $path_part;
            if (isset($parsed_url['query']))
                $new_url .= '?' . $parsed_url['query'];
            if (isset($parsed_url['fragment']))
                $new_url .= '#' . $parsed_url['fragment'];

            $this->db->where('id', $link->id)
                ->update('links', ['url' => $new_url]);
        }

        return true;
    }
}