<div class="container-fluid py-4" style="background: #f4f6fb; min-height: 100vh;">
    <!-- Header Minimalis -->
    <div class="d-flex justify-content-between align-items-center py-3 border-bottom mb-4">
        <h4 class="fw-semibold text-dark mb-0">Dashboard Monitoring</h4>
        <small id="dateTimeDisplay" class="text-muted"></small>
    </div>

    <!-- Stats Cards Minimalis -->
    <div class="row g-3">
        <div class="col-md-4">
            <div class="card border-0 bg-light text-center py-3">
                <div class="mb-2">
                    <span class="d-inline-flex align-items-center justify-content-center rounded-circle"
                        style="width:40px; height:40px; background:#e8f0fe; color:#1a73e8;">
                        <i class="bi bi-globe2"></i>
                    </span>
                </div>
                <div class="fw-semibold text-muted small">Total Domain</div>
                <div class="fs-3 fw-bold text-primary"><?= $total_domains ?></div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-0 bg-light text-center py-3">
                <div class="mb-2">
                    <span class="d-inline-flex align-items-center justify-content-center rounded-circle"
                        style="width:40px; height:40px; background:#e6f4ea; color:#34a853;">
                        <i class="bi bi-diagram-3"></i>
                    </span>
                </div>
                <div class="fw-semibold text-muted small">Total Path</div>
                <div class="fs-3 fw-bold text-success"><?= $total_paths ?></div>
            </div>
        </div>
    </div>

    <!-- Shortlink Generator -->
    <div class="row mt-5">
        <div class="col-12">
            <h5 class="fw-bold mb-3">🔗 Generate Shortlink</h5>
            <div class="card glass-card shadow-lg border-0">
                <div class="card-body">
                    <form class="d-flex gap-2" action="<?= base_url('dashboard/generate_shortlink') ?>" method="post">
                        <input type="url" class="form-control form-control-lg" id="url" name="url"
                            placeholder="Paste long url here..." required>
                        <button type="submit" class="btn btn-lg btn-warning fw-bold px-4">
                            <i class="bi bi-link-45deg"></i> Generate
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Latest Shortlinks -->
    <div class="row mt-5">
        <div class="col-12">
            <h5 class="fw-bold mb-3">📌 Latest Shortlinks</h5>
            <div class="card shadow-lg border-0">
                <div class="card-body table-responsive">
                    <?php if (!empty($latest_shortlinks)): ?>
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Shortlink</th>
                                    <th class="text-end">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($latest_shortlinks as $link): ?>
                                    <tr>
                                        <td>
                                            <a href="<?= $link->shortlink ?>" target="_blank"
                                                class="fw-bold text-decoration-none text-dark">
                                                <?= $link->shortlink ?>
                                            </a>
                                        </td>
                                        <td class="text-end">
                                            <button class="btn btn-sm btn-outline-warning copy-btn"
                                                data-link="<?= htmlspecialchars($link->shortlink) ?>">
                                                <i class="bi bi-clipboard"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-info qr-btn"
                                                data-link="<?= htmlspecialchars($link->shortlink) ?>">
                                                <i class="bi bi-qr-code"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger remove-btn" data-id="<?= $link->id ?>"
                                                data-table="<?= $link->_table ?? 'links' ?>">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center text-muted">Belum ada shortlink.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- QR Code Modal -->
<div class="modal fade" id="qrCodeModal" tabindex="-1" aria-labelledby="qrCodeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="qrCodeModalLabel">QR Code</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <canvas id="qrCodeContainer"></canvas>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom Styles -->
<style>
    .stats-card:hover {
        transform: translateY(-5px);
        transition: 0.3s ease;
    }

    .icon-wrapper {
        width: 70px;
        height: 70px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
    }

    .glass-card {
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(6px);
        border-radius: 15px;
    }

    .btn-outline-warning {
        color: #ff6600;
        border-color: #ff6600;
    }

    .btn-outline-warning:hover {
        background: #ff6600;
        color: #fff;
    }

    .btn-outline-danger {
        color: #ff3300;
        border-color: #ff3300;
    }

    .btn-outline-danger:hover {
        background: #ff3300;
        color: #fff;
    }
</style>


<!-- Add jQuery inclusion -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
<!-- Add SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function () {
        // Copy button functionality
        $('.copy-btn').click(function () {
            const link = $(this).data('link');
            if (!link) return;
            navigator.clipboard.writeText(link).then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Copied!',
                    text: 'Copied to clipboard: ' + link,
                    timer: 2000,
                    showConfirmButton: false
                });
            }).catch(() => {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    text: 'Failed to copy',
                    timer: 2000,
                    showConfirmButton: false
                });
            });
        });

        // QR Code button functionality
        $('.qr-btn').click(function () {
            const link = $(this).data('link');
            if (!link) return;
            $('#qrCodeContainer').empty();
            QRCode.toCanvas(document.getElementById('qrCodeContainer'), link, { width: 200 }, function (error) {
                if (error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'Failed to generate QR code',
                        timer: 2000,
                        showConfirmButton: false
                    });
                    return;
                }
                // Use Bootstrap 5 modal API to show modal
                var qrModal = new bootstrap.Modal(document.getElementById('qrCodeModal'));
                qrModal.show();
            });
        });

        // Remove button functionality
        $('.remove-btn').click(function () {
            const id = $(this).data('id');
            const table = $(this).data('table');
            if (!id || !table) return;
            Swal.fire({
                title: 'Are you sure?',
                text: "Are you sure you want to remove this shortlink?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, remove it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Send AJAX request to remove the link
                    $.ajax({
                        url: '<?= base_url('dashboard/remove_shortlink') ?>',
                        method: 'POST',
                        data: { id: id, table: table },
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Removed!',
                                    text: 'Shortlink removed successfully.',
                                    timer: 2000,
                                    showConfirmButton: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Failed',
                                    text: 'Failed to remove shortlink: ' + (response.message || 'Unknown error'),
                                    timer: 3000,
                                    showConfirmButton: true
                                });
                            }
                        },
                        error: function () {
                            Swal.fire({
                                icon: 'error',
                                title: 'Failed',
                                text: 'Failed to remove shortlink.',
                                timer: 3000,
                                showConfirmButton: true
                            });
                        }
                    });
                }
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        // Load latest shortlinks on page load
        loadLatestShortlinks();

        function loadLatestShortlinks() {
            // For simplicity, we'll load from a sample or you can implement an AJAX endpoint
            // Since we don't have a specific endpoint, we'll leave this for now
            // You can add an AJAX call here to fetch latest shortlinks
        }

        // Show flash messages with SweetAlert if any
        <?php if ($this->session->flashdata('success')): ?>
            Swal.fire({
                icon: 'success',
                title: 'Success',
                text: '<?= $this->session->flashdata('success') ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>
        <?php if ($this->session->flashdata('error')): ?>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: '<?= $this->session->flashdata('error') ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>
    });
</script>

<!-- Dd/Mm/Yy (Times) -->
<script>
    function updateDateTime() {
        const options = {
            weekday: 'long',   // Senin, Selasa, ...
            year: 'numeric',
            month: 'long',    // Januari, Februari, ...
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit',
            second: '2-digit'
        };
        const now = new Date();
        document.getElementById('dateTimeDisplay').textContent =
            now.toLocaleDateString('id-ID', options);
    }

    // Update setiap detik
    setInterval(updateDateTime, 1000);
    updateDateTime();
</script>