<div class="container-fluid mt-4">
    <h3 class="mb-3">Daftar Domain</h3>

    <!-- Form Pencarian -->
    <form class="row g-2 mb-3" method="get" action="<?= base_url('domain') ?>">
        <div class="col-md-4">
            <input type="text" name="search" class="form-control" placeholder="Cari domain atau API key..."
                value="<?= htmlspecialchars((string) ($_GET['search'] ?? '')) ?>">
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Cari</button>
        </div>
    </form>

    <div class="mb-3">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addDomainModal">Add
            Domain</button>
    </div>

    <!-- Tabel Domain -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Domain</th>
                    <th>API Key</th>
                    <th>Status</th>
                    <th width="150">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($domains)): ?>
                    <?php foreach ($domains as $domain): ?>
                        <tr>
                            <td>
                                <?php
                                    $fullUrl = $domain->domain_name ?? '';
                                    // Add http:// if protocol missing
                                    if (!preg_match('#^https?://#i', $fullUrl)) {
                                        $fullUrl = 'http://' . $fullUrl;
                                    }
                                    // Remove protocol for display
                                    $displayDomain = preg_replace('#^https?://#i', '', $domain->domain_name ?? '');
                                ?>
                                <a href="<?= htmlspecialchars($fullUrl) ?>" target="_blank" rel="noopener noreferrer">
                                    <?= htmlspecialchars($displayDomain) ?>
                                </a>
                            </td>
                            <td><code><?= htmlspecialchars((string) ($domain->api_key ?? '')) ?></code></td>
                            <td>
                                <?php if ($domain->status == 'active'): ?>
                                    <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Nonaktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                    data-bs-target="#editDomainModal"
                                    onclick="editDomain(<?= $domain->id ?>, '<?= addslashes((string) ($domain->domain_name ?? '')) ?>', '<?= addslashes((string) ($domain->domain_name ?? '')) ?>', '<?= addslashes((string) ($domain->api_key ?? '')) ?>')">Edit</button>
                                <button type="button" class="btn btn-sm btn-danger"
                                    onclick="deleteDomain(<?= $domain->id ?>, '<?= addslashes((string) ($domain->domain_name ?? '')) ?>')">Hapus</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">Belum ada data domain</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Add Domain Modal -->
    <div class="modal fade" id="addDomainModal" tabindex="-1" aria-labelledby="addDomainModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addDomainModalLabel">Tambah / Ganti Domain</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="<?= site_url('domain/add') ?>">
                        <div class="mb-3">
                            <label for="old_domain" class="form-label">Domain Lama</label>
                            <input type="text" class="form-control" id="old_domain" name="old_domain"
                                placeholder="contoh: jablay123ku.click" required>
                            <div class="form-text">Isi dengan domain lama yang ingin diganti.</div>
                        </div>
                        <div class="mb-3">
                            <label for="new_domain" class="form-label">Domain Baru</label>
                            <input type="text" class="form-control" id="new_domain" name="new_domain"
                                placeholder="contoh: virtualcheers.org" required>
                            <div class="form-text">Isi dengan domain baru pengganti domain lama.</div>
                        </div>
                        <div class="mb-3">
                            <label for="api_key" class="form-label">API Key</label>
                            <input type="text" class="form-control" id="api_key" name="api_key"
                                placeholder="Masukkan API Key dari cutt.ly" required>
                            <div class="form-text">Gunakan API Key dari akun cutt.ly Pro.</div>
                        </div>
                        <button type="submit" class="btn btn-success w-100">🚀 Simpan Perubahan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Domain Modal -->
    <div class="modal fade" id="editDomainModal" tabindex="-1" aria-labelledby="editDomainModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editDomainModalLabel">Edit Domain</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" id="editForm">
                        <div class="mb-3">
                            <label for="edit_old_domain" class="form-label">Domain Lama</label>
                            <input type="text" class="form-control" id="edit_old_domain" name="old_domain" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_new_domain" class="form-label">Domain Baru</label>
                            <input type="text" class="form-control" id="edit_new_domain" name="new_domain" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_api_key" class="form-label">API Key</label>
                            <input type="text" class="form-control" id="edit_api_key" name="api_key" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function editDomain(id, old_domain, new_domain, api_key) {
            document.getElementById('editForm').action = '<?= base_url('domain/edit/') ?>' + id;
            document.getElementById('edit_old_domain').value = old_domain;
            document.getElementById('edit_new_domain').value = new_domain;
            document.getElementById('edit_api_key').value = api_key;
        }

        function deleteDomain(id, old_domain) {
            Swal.fire({
                title: 'Hapus Domain?',
                text: 'Apakah Anda yakin ingin menghapus domain ' + old_domain + '?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, Hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = '<?= base_url('domain/delete/') ?>' + id;
                }
            });
        }

        // Popup notifications
        <?php if ($this->session->flashdata('success')): ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: '<?= addslashes($this->session->flashdata('success')) ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            Swal.fire({
                icon: 'error',
                title: 'Gagal!',
                text: '<?= addslashes($this->session->flashdata('error')) ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>
    </script>
</div>