<div class="container-fluid mt-4">
    <h3>Migration Mass Replace Domain</h3>
    <form method="post" action="<?= base_url('migration/mass_replace') ?>">
        <div class="mb-3">
            <label for="domain_id" class="form-label">Pilih Domain</label>
            <select name="domain_id" class="form-select" required>
                <?php foreach ($domains as $domain): ?>
                    <option value="<?= $domain->id ?>"><?= $domain->domain_name ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="cuttly_api_key" class="form-label">Cutt.ly API Key</label>
            <input type="text" name="cuttly_api_key" class="form-control" placeholder="Masukkan API Key Cutt.ly"
                required>
        </div>
        <button type="submit" class="btn btn-warning">Migrasi Massal</button>
    </form>
    <div class="mt-4">
        <h5>Notifikasi Migrasi</h5>
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?= $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?= $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>
        <?php $migration_errors = $this->session->flashdata('migration_errors'); ?>
        <?php if (!empty($migration_errors)): ?>
            <div class="alert alert-warning">
                <strong>Detail Error Migrasi:</strong>
                <ul>
                <?php foreach ($migration_errors as $err): ?>
                    <li>ID Path: <?= $err['path_id'] ?> | Old: <?= $err['old_url'] ?> | New: <?= $err['new_url'] ?> | Error: <?= $err['error'] ?></li>
                <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>

    <div class="mt-5">
        <h4>Riwayat Migrasi</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Domain</th>
                    <th>Jumlah Berhasil</th>
                    <th>Jumlah Gagal</th>
                    <th>Tanggal</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($migration_logs)): ?>
                    <?php foreach ($migration_logs as $log): ?>
                        <tr>
                            <td><?= isset($log->domain_name) ? $log->domain_name : '-' ?></td>
                            <td><?= isset($log->success_count) ? $log->success_count : (isset($log->total) ? $log->total : '-') ?></td>
                            <td><?= isset($log->failed_count) ? $log->failed_count : '-' ?></td>
                            <td><?= isset($log->created_at) ? $log->created_at : '-' ?></td>
                            <td>
                                <?php if (isset($log->id)): ?>
                                    <a href="<?= base_url('migration/restore_migration/' . $log->id) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin restore migrasi ini?')">Undo/Restore</a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5">Belum ada riwayat migrasi.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    </div>
</div>