<div class="modal fade" id="addPathModal" tabindex="-1" aria-labelledby="addPathModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="addPathForm" method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addPathModalLabel">Add New Path</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
            <label for="domain" class="form-label">Select Domain</label>
            <select name="domain" id="domain" class="form-select" required>
                <option value="">Select a domain</option>
                <?php foreach ($domains as $domain): ?>
                    <option value="<?= htmlspecialchars($domain->domain) ?>"><?= htmlspecialchars($domain->name) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="path" class="form-label">Path (optional)</label>
            <input type="text" name="path" id="path" class="form-control" placeholder="Enter path">
        </div>
        <div class="mb-3">
            <label for="shortlink" class="form-label">Shortlink</label>
            <input type="text" name="shortlink" id="shortlink" class="form-control" placeholder="Enter shortlink manually or generate">
        </div>
        <button type="button" class="btn btn-secondary mb-3" id="btnGenerateShortlink">Generate Shortlink</button>
        <input type="hidden" name="status" value="active">
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Add Path</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>
<div id="notif"></div>

<!-- Modal -->
<div class="modal fade" id="generateShortlinkModal" tabindex="-1" aria-labelledby="generateShortlinkModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="generateShortlinkForm" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="generateShortlinkModalLabel">Generate Shortlink</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
          <div class="mb-3">
              <label for="api_key" class="form-label">API Key Cuttly</label>
              <input type="text" class="form-control" id="api_key" name="api_key" required>
          </div>
          <div class="mb-3">
              <label for="custom_shortlink" class="form-label">Custom Shortlink (optional)</label>
              <input type="text" class="form-control" id="custom_shortlink" name="custom_shortlink" placeholder="https://cutt.ly/namaku">
          </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Generate</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script>
    document.getElementById('addPathForm').addEventListener('submit', function (e) {
        e.preventDefault();
        var form = e.target;
        var data = new FormData(form);
        fetch('<?= base_url('pertoko/add_path_ajax/' . $toko_slug) ?>', {
            method: 'POST',
            body: data
        })
            .then(res => res.json())
            .then(res => {
                document.getElementById('notif').innerHTML = res.message;
                if (res.success) {
                    form.reset();
                    // Ambil data path terbaru dan update tampilan
                    fetch('<?= base_url('pertoko/get_paths_by_domain/' . $toko_slug) ?>?domain=' + document.getElementById('domain').value)
                        .then(r => r.json())
                        .then(paths => {
                            // update tampilan list path di sini
                        });
                }
            })
            .catch(err => {
                document.getElementById('notif').innerHTML = 'Terjadi error: ' + err;
            });
    });

    var generateModal = new bootstrap.Modal(document.getElementById('generateShortlinkModal'));

    document.getElementById('btnGenerateShortlink').addEventListener('click', function () {
        generateModal.show();
    });

    document.getElementById('generateShortlinkForm').addEventListener('submit', function (e) {
        e.preventDefault();
        var apiKey = document.getElementById('api_key').value;
        var customShortlink = document.getElementById('custom_shortlink').value;
        var domain = document.getElementById('domain').value;
        var path = document.getElementById('path').value;

        if (!apiKey) {
            alert('API Key is required');
            return;
        }
        if (!domain) {
            alert('Domain must be selected');
            return;
        }

        var formData = new FormData();
        formData.append('api_key', apiKey);
        formData.append('custom', customShortlink);
        formData.append('domain', domain);
        formData.append('path', path);

        fetch('<?= base_url('pertoko/generate_shortlink_ajax') ?>', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(res => {
            if (res.success) {
                document.getElementById('shortlink').value = res.shortlink;
                generateModal.hide();
            } else {
                alert('Failed to generate shortlink: ' + res.message);
            }
        })
        .catch(err => {
            alert('Error: ' + err);
        });
    });
</script>
