<div class="container-fluid mt-4">
    <!-- Flashdata Notifications will be shown as SweetAlert2 popups -->

    <h3 class="mb-3">My Links Management - <?= htmlspecialchars($toko) ?></h3>

    <!-- Search Form -->
    <form class="row g-2 mb-3" method="get" action="<?= base_url('pertoko/view/' . $toko_slug) ?>">
        <div class="col-md-4">
            <input type="text" name="search" class="form-control" placeholder="Search domain, path, or shortlink..."
                value="<?= htmlspecialchars((string) ($search ?? '')) ?>">
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Search</button>
        </div>
    </form>

    <div class="d-flex flex-wrap gap-3 mb-3">
        <button type="button" class="btn btn-gradient-primary" data-bs-toggle="modal" data-bs-target="#addDomainModal"
            data-toko="<?= htmlspecialchars($toko_slug) ?>">
            <i class="bi bi-plus-circle me-2"></i> Add Domain
        </button>

        <button type="button" class="btn btn-gradient-primary" data-bs-toggle="modal" data-bs-target="#addPathModal">
            <i class="bi bi-plus-circle me-2"></i> Add New Path
        </button>

        <button type="button" class="btn btn-gradient-warning ms-2" data-bs-toggle="modal" data-bs-target="#editPathAllModal">
            <i class="bi bi-pencil-square me-2"></i> Edit Path Semua
        </button>
    </div>

    <!-- Add Domain Modal -->
    <div class="modal fade" id="addDomainModal" tabindex="-1" aria-labelledby="addDomainModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="addDomainForm" method="post" action="<?= base_url('pertoko/add_domain/' . $toko_slug) ?>">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addDomainModalLabel">Add Domain for <?= htmlspecialchars($toko) ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="tokoName" class="form-label">Nama Toko</label>
                            <input type="text" class="form-control" id="tokoName" value="<?= htmlspecialchars($toko) ?>"
                                readonly>
                        </div>
                        <div class="mb-3">
                            <label for="domainName" class="form-label">Domain</label>
                            <input type="text" class="form-control" id="domainName" name="domain_name"
                                placeholder="Enter new domain..." required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save Domain</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Add New Path Modal -->
    <div class="modal fade" id="addPathModal" tabindex="-1" aria-labelledby="addPathModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="addPathForm" method="post" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addPathModalLabel">Add New Path</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                        <div class="mb-3">
                            <label for="pathDomain" class="form-label">Select Domain</label>
<select name="domain" id="pathDomain" class="form-select" required>
    <option value="">Select a domain</option>
    <?php
    $unique_domains = [];
    foreach ($all_domains as $domain) {
        if (!in_array($domain->domain_name, $unique_domains)) {
            $unique_domains[] = $domain->domain_name;
            echo '<option value="' . htmlspecialchars($domain->domain_name) . '">' . htmlspecialchars($domain->domain_name) . '</option>';
        }
    }
    ?>
</select>
                        </div>
                        <div class="mb-3">
                            <label for="pathInput" class="form-label">Path</label>
                            <input type="text" name="path" id="pathInput" class="form-control" placeholder="Enter path"
                                required>
                        </div>
                        <div class="mb-3">
                            <label for="shortlinkInput" class="form-label">Shortlink</label>
                            <input type="text" name="shortlink" id="shortlinkInput" class="form-control" placeholder="Enter shortlink manually or generate">
                        </div>
                        <button type="button" class="btn btn-secondary mb-3" id="btnGenerateShortlink">Generate Shortlink</button>
                        <input type="hidden" name="status" value="active">
                        <input type="hidden" name="toko_slug" value="<?= $toko_slug ?>">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="submitPathBtn">Add Path</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Edit Path Modal -->
    <div class="modal fade" id="editPathModal" tabindex="-1" aria-labelledby="editPathModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editPathModalLabel">Edit Path</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editPathForm">
                        <input type="hidden" id="editPathId" name="id">
                        <input type="hidden" name="toko_slug" value="<?= $toko_slug ?>">
                        <div class="mb-3">
                            <label for="editDomain" class="form-label">Domain</label>
                            <input type="text" class="form-control" id="editDomain" name="domain" required>
                        </div>
                        <div class="mb-3">
                            <label for="editPath" class="form-label">Path</label>
                            <input type="text" class="form-control" id="editPath" name="path" required>
                        </div>
                        <div class="mb-3">
                            <label for="editStatus" class="form-label">Status</label>
                            <select class="form-select" id="editStatus" name="status" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="submitEditPathBtn">Update Path</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Path Semua Modal -->
    <div class="modal fade" id="editPathAllModal" tabindex="-1" aria-labelledby="editPathAllModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <form id="editPathAllForm" method="post" action="<?= base_url('pertoko/edit_path_all/' . $toko_slug) ?>">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editPathAllModalLabel">Edit Path Semua</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="domainSelect" class="form-label">Pilih Domain</label>
                            <select class="form-select" id="domainSelect" name="domain" required>
                                <option value="">-- Pilih Domain --</option>
                                <?php
                                $unique_domains = [];
                                foreach ($domains as $domain) {
                                    if (!in_array($domain['name'], $unique_domains)) {
                                        $unique_domains[] = $domain['name'];
                                        echo '<option value="' . htmlspecialchars($domain['name']) . '">' . htmlspecialchars($domain['name']) . '</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="oldPathSelect" class="form-label">Pilih Path Lama</label>
                            <select class="form-select" id="oldPathSelect" name="old_path" required>
                                <option value="">-- Pilih Path Lama --</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="newPathInput" class="form-label">Input Path Baru</label>
                            <input type="text" class="form-control" id="newPathInput" name="new_path" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Update Paths</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const domainSelect = document.getElementById('domainSelect');
            const oldPathSelect = document.getElementById('oldPathSelect');

            // Generate Shortlink Modal
            var generateModalHtml = `
            <div class="modal fade" id="generateShortlinkModal" tabindex="-1" aria-labelledby="generateShortlinkModalLabel" aria-hidden="true">
              <div class="modal-dialog">
                <form id="generateShortlinkForm" class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="generateShortlinkModalLabel">Generate Shortlink</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                      <div class="mb-3">
                          <label for="api_key" class="form-label">API Key Cuttly</label>
                          <input type="text" class="form-control" id="api_key" name="api_key" required>
                      </div>
                      <div class="mb-3">
                          <label for="custom_shortlink" class="form-label">Custom Shortlink (optional)</label>
                          <input type="text" class="form-control" id="custom_shortlink" name="custom_shortlink" placeholder="https://cutt.ly/namaku">
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Generate</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                  </div>
                </form>
              </div>
            </div>
            `;
            document.body.insertAdjacentHTML('beforeend', generateModalHtml);
            var generateModal = new bootstrap.Modal(document.getElementById('generateShortlinkModal'));

            document.getElementById('btnGenerateShortlink').addEventListener('click', function () {
                generateModal.show();
            });

            document.getElementById('generateShortlinkForm').addEventListener('submit', function (e) {
                e.preventDefault();
                var apiKey = document.getElementById('api_key').value;
                var customShortlink = document.getElementById('custom_shortlink').value;
                var domain = document.getElementById('pathDomain').value;
                var path = document.getElementById('pathInput').value;

                if (!apiKey) {
                    alert('API Key is required');
                    return;
                }
                if (!domain) {
                    alert('Domain must be selected');
                    return;
                }

                var formData = new FormData();
                formData.append('api_key', apiKey);
                formData.append('custom', customShortlink);
                formData.append('domain', domain);
                formData.append('path', path);

                fetch('<?= base_url('pertoko/generate_shortlink_ajax') ?>', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        document.getElementById('shortlinkInput').value = res.shortlink;
                        generateModal.hide();
                    } else {
                        alert('Failed to generate shortlink: ' + res.message);
                    }
                })
                .catch(err => {
                    alert('Error: ' + err);
                });
            });

            domainSelect.addEventListener('change', function () {
                const domain = this.value;
                oldPathSelect.innerHTML = '<option value="">-- Pilih Path Lama --</option>';
                if (!domain) return;

                fetch('<?= base_url('pertoko/get_paths_by_domain/' . $toko_slug) ?>/' + encodeURIComponent(domain))
                    .then(response => response.json())
                    .then(data => {
                        const uniquePaths = [...new Set(data.map(item => item.path))];
                        uniquePaths.forEach(path => {
                            const option = document.createElement('option');
                            option.value = path;
                            option.textContent = path;
                            oldPathSelect.appendChild(option);
                        });
                    })
                    .catch(error => {
                        console.error('Error fetching paths:', error);
                    });
            });

            // Add New Path Modal functionality
            const addPathForm = document.getElementById('addPathForm');
            const submitPathBtn = document.getElementById('submitPathBtn');

            submitPathBtn.addEventListener('click', function () {
                const formData = new FormData(addPathForm);

                // Validate form
                const domain = formData.get('domain');
                const path = formData.get('path');

                if (!domain || !path) {
                    alert('Please fill in all required fields');
                    return;
                }

                // Show loading state
                submitPathBtn.disabled = true;
                submitPathBtn.textContent = 'Adding...';

                // Send AJAX request
                fetch('<?= base_url('pertoko/add_path_ajax/' . $toko_slug) ?>', {
                    method: 'POST',
                    body: formData
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Success - close modal and reload page
                            const modal = bootstrap.Modal.getInstance(document.getElementById('addPathModal'));
                            modal.hide();
                            location.reload();
                        } else {
                            // Error - show message
                            alert(data.message || 'Error adding path');
                            submitPathBtn.disabled = false;
                            submitPathBtn.textContent = 'Add Path';
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('An error occurred while adding the path');
                        submitPathBtn.disabled = false;
                        submitPathBtn.textContent = 'Add Path';
                    });
            });

            // Edit Path Modal functionality
            const editPathForm = document.getElementById('editPathForm');
            const submitEditPathBtn = document.getElementById('submitEditPathBtn');
            const editPathModal = new bootstrap.Modal(document.getElementById('editPathModal'));

            // Handle edit button clicks
            document.querySelectorAll('.edit-btn').forEach(btn => {
                btn.addEventListener('click', function () {
                    const id = this.dataset.id;
                    const domain = this.dataset.domain;
                    const path = this.dataset.path;
                    const status = this.dataset.status;

                    // Fill the form with existing data
                    document.getElementById('editPathId').value = id;
                    document.getElementById('editDomain').value = domain;
                    document.getElementById('editPath').value = path;
                    document.getElementById('editStatus').value = status;

                    // Show the modal
                    editPathModal.show();
                });
            });

            submitEditPathBtn.addEventListener('click', function () {
                const formData = new FormData(editPathForm);

                // Validate form
                const domain = formData.get('domain');
                const path = formData.get('path');
                const status = formData.get('status');

                if (!domain || !path || !status) {
                    alert('Please fill in all required fields');
                    return;
                }

                // Show loading state
                submitEditPathBtn.disabled = true;
                submitEditPathBtn.textContent = 'Updating...';

                // Send AJAX request
                fetch('<?= base_url('pertoko/update_path_ajax/' . $toko_slug) ?>', {
                    method: 'POST',
                    body: formData
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Success - close modal and reload page
                            editPathModal.hide();
                            location.reload();
                        } else {
                            // Error - show message
                            alert(data.message || 'Error updating path');
                            submitEditPathBtn.disabled = false;
                            submitEditPathBtn.textContent = 'Update Path';
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('An error occurred while updating the path');
                        submitEditPathBtn.disabled = false;
                        submitEditPathBtn.textContent = 'Update Path';
                    });
            });

            // SweetAlert2 for flashdata notifications
            <?php if ($this->session->flashdata('success')): ?>
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: '<?= addslashes($this->session->flashdata('success')) ?>',
                    timer: 3000,
                    showConfirmButton: false
                });
            <?php endif; ?>

            <?php if ($this->session->flashdata('error')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: '<?= addslashes($this->session->flashdata('error')) ?>',
                    timer: 3000,
                    showConfirmButton: false
                });
            <?php endif; ?>
        });
    </script>

    <!-- Table for Existing Domains -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Domain</th>
                    <th>Path</th>
                    <th>URL</th>
                    <th>Shortlink</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th width="150">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($domains)): ?>
                    <?php foreach ($domains as $domain): ?>
                        <?php foreach ($domain['paths'] as $path): ?>
                            <tr>
                                <td><?= htmlspecialchars($domain['name']) ?></td>
                                <td><?= htmlspecialchars($path->path) ?></td>
                                <td>
                                    <a href="<?= htmlspecialchars($path->url) ?>" target="_blank"
                                        title="<?= htmlspecialchars($path->url) ?>">
                                        <?= htmlspecialchars($path->url) ?>
                                    </a>
                                </td>
                                <td>
                                    <a href="<?= htmlspecialchars($path->shortlink) ?>" target="_blank"
                                        title="<?= htmlspecialchars($path->shortlink) ?>">
                                        <?= htmlspecialchars($path->shortlink) ?>
                                    </a>
                                </td>
                                <td>
                                    <span class="badge <?= $path->status == 'active' ? 'bg-success' : 'bg-secondary' ?>">
                                        <?= ucfirst($path->status) ?>
                                    </span>
                                </td>
                                <td><?= date('Y-m-d', strtotime($path->created_at)) ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-warning edit-btn" data-id="<?= $path->id ?>"
                                        data-domain="<?= htmlspecialchars($domain['name']) ?>"
                                        data-path="<?= htmlspecialchars($path->path) ?>" data-status="<?= $path->status ?>">
                                        Edit
                                    </button>
                                    <a href="<?= base_url('pertoko/delete/' . $toko_slug . '/' . $path->id) ?>"
                                        class="btn btn-sm btn-danger"
                                        onclick="return confirm('Yakin ingin menghapus data ini?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">No domains found</td>
                        </tr>
                    <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>