<div class="container-fluid mt-4" style="max-width:850px;">
    <div class="card shadow-sm rounded-4 p-4 d-flex flex-row gap-5 align-items-start">

        <!-- Foto Profil -->
        <div class="profile-pic-wrapper text-center">
            <div class="profile-badge mb-3">Profil</div>
            <img src="<?= base_url('uploads/profile/' . ($user->photo ?? 'default.png')) ?>" alt="Profile"
                class="profile-pic mb-3">
            <input type="file" class="form-control form-control-sm" id="profile_photo" name="profile_photo">
        </div>

        <!-- Form Profil -->
        <div class="flex-grow-1">
            <h3 class="fw-bold mb-4">Profil User</h3>

            <form method="post" action="<?= base_url('profile/edit') ?>" enctype="multipart/form-data">
                <div class="mb-3">
                    <label for="name" class="form-label fw-semibold">Nama</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?= $user->name ?>" required>
                </div>

                <div class="mb-3">
                    <label for="email" class="form-label fw-semibold">Email</label>
                    <input type="email" class="form-control" id="email" name="email" value="<?= $user->email ?>"
                        required>
                </div>

                <div class="d-flex flex-wrap gap-3 mt-4">
                    <button type="submit" class="btn btn-primary fw-bold px-5 py-2">💾 Simpan</button>
                    <button type="button" class="btn btn-warning fw-bold px-5 py-2" data-bs-toggle="modal"
                        data-bs-target="#changePasswordModal">
                        🔒 Ubah Password
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Ubah Password -->
<div class="modal fade" id="changePasswordModal" tabindex="-1" aria-labelledby="changePasswordModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 shadow-sm">
            <div class="modal-header">
                <h5 class="modal-title fw-bold" id="changePasswordModalLabel">Ubah Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="<?= base_url('profile/change_password') ?>">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="new_password" class="form-label">Password Baru</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" required>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password"
                            required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary fw-bold">Simpan</button>
                    <button type="button" class="btn btn-secondary fw-bold" data-bs-dismiss="modal">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .profile-pic-wrapper {
        min-width: 140px;
        text-align: center;
    }

    .profile-badge {
        font-weight: 700;
        font-size: 0.85rem;
        color: #4facfe;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .profile-pic {
        width: 140px;
        height: 140px;
        object-fit: cover;
        border-radius: 0.75rem;
        border: 2px solid #4facfe;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    }

    .card input.form-control {
        border-radius: 0.5rem;
        padding: 0.55rem 0.75rem;
        transition: border 0.2s ease, box-shadow 0.2s ease;
    }

    .card input.form-control:focus {
        border-color: #4facfe;
        box-shadow: 0 0 10px rgba(0, 175, 254, 0.4);
        outline: none;
    }

    .btn-primary {
        background: linear-gradient(90deg, #4facfe, #00f2fe);
        border: none;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 18px rgba(0, 175, 254, 0.4);
    }

    .btn-warning {
        background: linear-gradient(90deg, #f6d365, #fda085);
        border: none;
        transition: all 0.3s ease;
    }

    .btn-warning:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 18px rgba(253, 160, 133, 0.4);
    }
</style>