<!-- Sidebar -->
<nav class="sidebar d-flex flex-column vh-100 p-3">
  <!-- Brand -->
  <a href="<?= base_url('dashboard') ?>" class="d-flex align-items-center mb-4 text-decoration-none brand">
    <i class="bi me-2 fs-4 text-gradient"></i>
    <span class="fs-5 fw-bold">Shortlink</span>
  </a>

  <!-- Nav Items -->
  <ul class="nav flex-column mb-auto">
    <li class="nav-item">
      <a class="nav-link <?= ($this->uri->segment(1) == 'dashboard') ? 'active' : '' ?>" href="<?= base_url('dashboard') ?>">
        <i class="bi bi-house-door"></i>
        <span>Dashboard</span>
      </a>
    </li>
    <li>
      <a class="nav-link <?= ($this->uri->segment(1) == 'profile') ? 'active' : '' ?>" href="<?= base_url('profile') ?>">
        <i class="bi bi-person"></i>
        <span>Profile</span>
      </a>
    </li>
    <li>
      <a class="nav-link <?= ($this->uri->segment(1) == 'domain') ? 'active' : '' ?>" href="<?= base_url('domain') ?>">
        <i class="bi bi-globe"></i>
        <span>Domain</span>
      </a>
    </li>

    <!-- Dropdown Pertoko -->
    <li>
      <a class="nav-link dropdown-toggle <?= ($this->uri->segment(1) == 'pertoko') ? 'active' : '' ?>" 
         href="#" id="dropdownPertoko" data-bs-toggle="collapse" data-bs-target="#pertokoMenu">
        <i class="bi bi-shop"></i>
        <span>Pertoko</span>
      </a>
      <div class="collapse <?= ($this->uri->segment(1) == 'pertoko') ? 'show' : '' ?>" id="pertokoMenu">
        <ul class="nav flex-column ms-3">
          <?php
          $toko_list = [
            'Ompong188', 'Botak123', 'Sakti123', 'Pasar123', 'Cuan123', 
            'Jablay123', 'Candu123', 'Mampir123', 'Becekwin', 'Jenius196', 'Gendut188'
          ];
          foreach ($toko_list as $toko): ?>
            <li>
              <a class="nav-link sub-link" href="<?= base_url('pertoko/view/' . strtolower($toko)) ?>">
                <?= $toko ?>
              </a>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </li>

    <li>
      <a class="nav-link <?= ($this->uri->segment(1) == 'migration') ? 'active' : '' ?>" href="<?= base_url('migration') ?>">
        <i class="bi bi-arrow-repeat"></i>
        <span>Migration</span>
      </a>
    </li>
  </ul>

  <!-- Logout -->
  <hr>
  <a class="nav-link logout" href="<?= base_url('auth/logout') ?>">
    <i class="bi bi-box-arrow-right"></i>
    <span>Logout</span>
  </a>
</nav>

<!-- Custom CSS -->
<style>
  .sidebar {
    background: #000000ff;
    border-right: 1px solid #e5e7eb;
    min-width: 240px;
    font-family: 'Segoe UI', sans-serif;
  }
  .sidebar .brand {
    font-size: 1.2rem;
    color: #ffffffff;
  }
  .sidebar .text-gradient {
    background: linear-gradient(135deg, #667eea, #764ba2);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  .sidebar .nav-link {
    color: #ffffffff;
    border-radius: 0.5rem;
    padding: 0.65rem 1rem;
    margin-bottom: 0.3rem;
    display: flex;
    align-items: center;
    font-weight: 500;
    transition: all 0.25s ease;
  }
  .sidebar .nav-link i {
    font-size: 1.2rem;
    margin-right: 0.75rem;
    color: #ffffffff;
  }
  .sidebar .nav-link:hover {
    background: #f3f4f6;
    color: #111827;
  }
  .sidebar .nav-link.active {
    background: linear-gradient(90deg, #4facfe, #00f2fe);
    color: #fff !important;
  }
  .sidebar .nav-link.active i {
    color: #fff;
  }
  .sidebar .sub-link {
    font-size: 0.9rem;
    padding: 0.4rem 1rem;
    color: #6b7280;
  }
  .sidebar .sub-link:hover {
    color: #111827;
  }
  .sidebar .logout {
    color: #dc2626;
    font-weight: 600;
  }
  .sidebar .logout:hover {
    background: #fee2e2;
  }
</style>
