<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Include the CodeIgniter index.php to bootstrap the application
include_once 'index.php';

// Get the CI instance
$CI =& get_instance();

// Load the database library
$CI->load->database();

// Check if domains table exists
if ($CI->db->table_exists('domains')) {
    echo "Domains table exists.\n";
    
    // Get the table fields
    $fields = $CI->db->field_data('domains');
    echo "Table structure:\n";
    foreach ($fields as $field) {
        echo "Field: " . $field->name . " | Type: " . $field->type . " | Max Length: " . $field->max_length . " | Primary Key: " . ($field->primary_key ? 'Yes' : 'No') . "\n";
    }
    
    // Check if there's any data
    $count = $CI->db->count_all('domains');
    echo "Total records: " . $count . "\n";
    
    if ($count > 0) {
        $rows = $CI->db->get('domains', 5)->result();
        echo "Sample data:\n";
        foreach ($rows as $row) {
            print_r($row);
        }
    }
} else {
    echo "Domains table does not exist.\n";
}
?>
